IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationByHpioGet]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HealthProviderOrganisationByHpioGet]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================

-- Create date:   29/10/2013
-- Description:   Gets all records or a specific record from the HealthProviderOrganisation Table using Hpio
-- =============================================
CREATE PROCEDURE [hips].[HealthProviderOrganisationByHpioGet] 
(
	@Hpio VARCHAR(16)
)
AS
BEGIN
SELECT  hpo.HealthProviderOrganisationId,
		hpo.Name,
		hpo.HpiO,
		hpo.HiCertSerial,
		hpo.PcehrCertSerial,
		hpo.AuthorisedEmployeeName,
		hpo.AuthorisedEmployeeUserId,
		hpo.DateCreated,
		hpo.UserCreated,
		hpo.DateModified,
		hpo.UserModified,
		hpo.[HpoCertSerial],
		hpo.[HiCsp],
		hpo.[PcehrCsp],
		hpo.[HealthProviderOrganisationNetworkId]
FROM  hips.HealthProviderOrganisation hpo
WHERE hpo.Hpio = @Hpio
END
GO
